<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Produit extends Model 
{

    protected $table = 'produits';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('nom_produits', 'prix_produit', 'description_produit', 'categorie_id', 'image_produit', 'quantiter_stock');

    public function relationCategorie()
    {
        return $this->belongsTo('App\Models\Categorie');
    }

    public function relationLigneCommandes()
    {
        return $this->hasMany('App\Models\LigneCommande');
    }

}